/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import net.minecraft.nbt.CompoundTag;

public class SettingsManager {
    private final ITravelersBackpackContainer container;
    private byte[] craftingSettings = new byte[]{1, 1};
    public static final byte CRAFTING = 0;
    public static final int LOCK_CRAFTING_GRID = 0;
    public static final int RENDER_OVERLAY = 1;
    private final String CRAFTING_SETTINGS = "CraftingSettings";

    public SettingsManager(ITravelersBackpackContainer container) {
        this.container = container;
    }

    public boolean isCraftingGridLocked() {
        return this.getByte((byte)0, 0) == 1;
    }

    public boolean renderOverlay() {
        return this.getByte((byte)0, 1) == 1;
    }

    public byte getByte(byte dataArray, int place) {
        if (dataArray == 0) {
            return this.craftingSettings[place];
        }
        return 0;
    }

    public void set(byte selectedDataArray, int place, byte value) {
        byte[] dataArray = new byte[]{};
        if (selectedDataArray == 0) {
            dataArray = this.craftingSettings;
        }
        dataArray[place] = value;
        this.setChanged();
    }

    public void saveSettings(CompoundTag compound) {
        compound.m_128382_("CraftingSettings", this.craftingSettings);
    }

    public void loadSettings(CompoundTag compound) {
        byte[] byArray;
        if (compound.m_128441_("CraftingSettings")) {
            byArray = compound.m_128463_("CraftingSettings");
        } else {
            byte[] byArray2 = new byte[2];
            byArray2[0] = 1;
            byArray = byArray2;
            byArray2[1] = 1;
        }
        this.craftingSettings = byArray;
    }

    public void setChanged() {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(9);
        } else {
            this.container.setDataChanged();
        }
    }
}

